﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using VeteransAffairs.Registries.Business;
using VeteransAffairs.Registries.BusinessManager;

public partial class Biomonitoring : System.Web.UI.Page
{
    private int _workFlowId;

    protected int workFlowId
    {
        get { return _workFlowId; }
    }

    protected void Page_Load(object sender, EventArgs e)
    {
        _workFlowId = Convert.ToInt32(Request.Params.Get("caseId"));
        lblWorkflowID.Text = _workFlowId.ToString();

        BiomonitoringManager objBio = new BiomonitoringManager();
        WKF_CASE workFlow = objBio.GetWorkFlowCase(_workFlowId);
        if (workFlow != null)
        {
            PATIENT Patient = workFlow.PATIENT;
            REFERRAL Referral = workFlow.REFERRAL;
            STD_WKFCASEST CaseSt = workFlow.STD_WKFCASEST;
            lblVPID.Text = Patient.VPID_NUMBER.ToString();
            lblName.Text = Patient.FullName;
            lblReferral_Date.Text = Referral.REFERRAL_DATE.Value.ToShortDateString();
            lblCurrentStatus.Text = CaseSt.NAME;
            
            //Render the indicators
            IEnumerable<string> rd = from t in workFlow.REFERRAL.REFERRAL_DETAILs select t.STD_HEALTHFACTOR.NAME;
            lvIndicators.DataSource = rd;
            lvIndicators.DataBind();

            //Enable and disable hyperlinks depending on activity status
            //Check if the Biokit has been sent
            //If not sent, create shipment log(order?)
            
            //Get the activities
            IEnumerable<WKF_CASE_ACTIVITY> CaseActivity = objBio.GetCaseActivities(_workFlowId);
            WKF_CASE_ACTIVITY Activity = (from t in CaseActivity where (WorkFlowActivityTypes)t.STD_WKFACTIVITYTYPE_ID==WorkFlowActivityTypes.LabKit select t).FirstOrDefault();
            SHIPPING_DETAIL ShippingDetail = null;
            if (Activity == null)
            {
                this.HyperLinkTrackBioKit.Text = "Create shipment log";
                this.HyperLinkTrackBioKit.NavigateUrl = "LabKitOrder.aspx?wkid=" + _workFlowId.ToString();
                this.HyperLinkTrackBioKitReturn.Visible = false;
                this.PanelTrackBioKitReturn.Visible = false;
            }
            else
            {
                //If the kit has been sent, track shipment
                //TODO - If there are more shipments for a case activity, include correct shipment type here 
                ShippingDetail = Activity.SHIPPING_DETAILs[0];
                this.HyperLinkTrackBioKit.Text = "Track shipment";
                this.HyperLinkTrackBioKit.NavigateUrl = "LabKitOrder.aspx?shippingid=" + ShippingDetail.SHIPPING_DETAIL_ID.ToString();
                this.HyperLinkTrackBioKitReturn.Visible = true;
                this.PanelTrackBioKitReturn.Visible = true;
                this.HyperLinkTrackBioKitReturn.NavigateUrl = this.HyperLinkTrackBioKit.NavigateUrl;
                
                this.LabelWaitingForKitForPatient.Visible = true;

                if (ShippingDetail.RECEIVED_DATE.HasValue)
                    ImageOrderKitComplete.Visible = true;
            }
        
            //Check if bio sample has been received
            Activity =  (from t in CaseActivity where (WorkFlowActivityTypes)t.STD_WKFACTIVITYTYPE_ID==WorkFlowActivityTypes.LabKit select t).FirstOrDefault();
            if (Activity != null)
            {
                if (Activity.SHIPPING_DETAILs[0].RECEIVED_DATE.HasValue)
                {
                    ImageReceivePatientSpecimenComplete.Visible = true;
                    ShippingDetail = Activity.SHIPPING_DETAILs[0];
                    this.LabelWaitingForKitForPatient.Visible = false;
                    this.HyperLinkSurvey.Visible = true;
                    this.HyperLinkSurvey.Text = "Open questionnaire";
                    this.HyperLinkSurvey.NavigateUrl = "Survey.aspx?wkid=" + _workFlowId.ToString();

                    this.HyperLinkTrackLabOrder.Visible = true;
                    this.HyperLinkTrackLabOrder.Text = "Track Order";
                    this.HyperLinkTrackLabOrder.NavigateUrl = "LabWorkOrder.aspx?id=" + ShippingDetail.SHIPPING_DETAIL_ID.ToString();
                }
            }

            //Check if Lab work has been received
          
            Activity =  (from t in CaseActivity where (WorkFlowActivityTypes)t.STD_WKFACTIVITYTYPE_ID==WorkFlowActivityTypes.LabOrder select t).FirstOrDefault();
            
            //No shipping info. stored for these activities. Just an activity is recorded.
            if (Activity != null)
                ImageOrderLabResultsComplete.Visible = true;
            Activity =  (from t in CaseActivity where (WorkFlowActivityTypes)t.STD_WKFACTIVITYTYPE_ID==WorkFlowActivityTypes.LabOrder select t).FirstOrDefault();
            if (Activity != null)
                    HyperLinkPrintLetters.Visible = true;
            else
                this.HyperLinkTrackLabOrder.Visible = false;

            //Check if letters sent. 
            Activity = (from t in CaseActivity where (WorkFlowActivityTypes)t.STD_WKFACTIVITYTYPE_ID == WorkFlowActivityTypes.LetterSent select t).FirstOrDefault();
            if (Activity != null)
                ImageSendResultsComplete.Visible = true;

            //TODO - Generate letters here?
             }
        }

    

}
